<?php
if (!defined('ABSPATH')) {
    exit;
}

add_action('plugins_loaded', 'init_card2cryptogateway_kryptonimcom_gateway');

function init_card2cryptogateway_kryptonimcom_gateway() {
    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }

class Card2Crypto_Instant_Payment_Gateway_Kryptonim extends WC_Payment_Gateway {

    protected $icon_url;
    protected $kryptonimcom_wallet_address;
    protected $kryptonimcom_custom_domain;

    public function __construct() {
        $this->id                 = 'card2crypto-kryptonim';
        $this->icon = sanitize_url($this->get_option('icon_url'));
        $this->method_title       = esc_html__('Card2Crypto Payment Gateway with Instant Payouts (kryptonim.com)', 'instant-approval-payment-gateway'); // Escaping title
        $this->method_description = esc_html__('Card2Crypto High Risk Merchant Gateway with instant payouts to your USDC POLYGON wallet using kryptonim.com infrastructure', 'instant-approval-payment-gateway'); // Escaping description
        $this->has_fields         = false;

        $this->init_form_fields();
        $this->init_settings();

        $this->title       = sanitize_text_field($this->get_option('title'));
        $this->description = sanitize_text_field($this->get_option('description'));

        // Use the configured settings for redirect and icon URLs
        $this->kryptonimcom_custom_domain = rtrim(str_replace(['https://','http://'], '', sanitize_text_field($this->get_option('kryptonimcom_custom_domain'))), '/');
        $this->kryptonimcom_wallet_address = sanitize_text_field($this->get_option('kryptonimcom_wallet_address'));
        $this->icon_url     = sanitize_url($this->get_option('icon_url'));

        add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
    }

    public function init_form_fields() {
        $this->form_fields = array(
            'enabled' => array(
                'title'   => esc_html__('Enable/Disable', 'instant-approval-payment-gateway'), // Escaping title
                'type'    => 'checkbox',
                'label'   => esc_html__('Enable kryptonim.com payment gateway', 'instant-approval-payment-gateway'), // Escaping label
                'default' => 'no',
            ),
            'title' => array(
                'title'       => esc_html__('Title', 'instant-approval-payment-gateway'), // Escaping title
                'type'        => 'text',
                'description' => esc_html__('Payment method title that users will see during checkout.', 'instant-approval-payment-gateway'), // Escaping description
                'default'     => esc_html__('Kryptonim', 'instant-approval-payment-gateway'), // Escaping default value
                'desc_tip'    => true,
            ),
            'description' => array(
                'title'       => esc_html__('Description', 'instant-approval-payment-gateway'), // Escaping title
                'type'        => 'textarea',
                'description' => esc_html__('Payment method description that users will see during checkout.', 'instant-approval-payment-gateway'), // Escaping description
                'default'     => esc_html__('Pay via Kryptonim', 'instant-approval-payment-gateway'), // Escaping default value
                'desc_tip'    => true,
            ),
            'kryptonimcom_custom_domain' => array(
                'title'       => esc_html__('Advanced Custom Domain', 'instant-approval-payment-gateway'), // Escaping title
                'type'        => 'text',
                'description' => esc_html__('Advanced feature: Do not modify the default pay.card2crypto.org value. If you wish to use your own domain for checkout pages, refer to the API documentation for setup instructions (intended for developers only).', 'instant-approval-payment-gateway'), // Escaping description
                'default'     => esc_html__('pay.card2crypto.org', 'instant-approval-payment-gateway'), // Escaping default value
                'desc_tip'    => true,
            ),
            'kryptonimcom_wallet_address' => array(
                'title'       => esc_html__('Wallet Address', 'instant-approval-payment-gateway'), // Escaping title
                'type'        => 'text',
                'description' => esc_html__('Insert your USDC (Polygon) wallet address to receive instant payouts. Payouts maybe sent in ETH or USDC or USDT (Polygon or BEP-20) or POL native token. Same wallet should work to receive all. Make sure you use a self-custodial wallet to receive payouts.', 'instant-approval-payment-gateway'), // Escaping description
                'desc_tip'    => true,
            ),
            'icon_url' => array(
                'title'       => esc_html__('Icon URL', 'instant-approval-payment-gateway'), // Escaping title
                'type'        => 'url',
                'description' => esc_html__('Enter the URL of the icon image for the payment method.', 'instant-approval-payment-gateway'), // Escaping description
                'desc_tip'    => true,
            ),
        );
    }
	 // Add this method to validate the wallet address in wp-admin
    public function process_admin_options() {
		if (!isset($_POST['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'woocommerce-settings')) {
    WC_Admin_Settings::add_error(__('Nonce verification failed. Please try again.', 'instant-approval-payment-gateway'));
    return false;
}
        $kryptonimcom_admin_wallet_address = isset($_POST[$this->plugin_id . $this->id . '_kryptonimcom_wallet_address']) ? sanitize_text_field( wp_unslash( $_POST[$this->plugin_id . $this->id . '_kryptonimcom_wallet_address'])) : '';

        // Check if wallet address starts with "0x"
        if (substr($kryptonimcom_admin_wallet_address, 0, 2) !== '0x') {
            WC_Admin_Settings::add_error(__('Invalid Wallet Address: Please insert your USDC Polygon wallet address.', 'instant-approval-payment-gateway'));
            return false;
        }

        // Check if wallet address matches the USDC contract address
        if (strtolower($kryptonimcom_admin_wallet_address) === '0x3c499c542cef5e3811e1192ce70d8cc03d5c3359') {
            WC_Admin_Settings::add_error(__('Invalid Wallet Address: Please insert your USDC Polygon wallet address.', 'instant-approval-payment-gateway'));
            return false;
        }

        // Proceed with the default processing if validations pass
        return parent::process_admin_options();
    }
    public function process_payment($order_id) {
        $order = wc_get_order($order_id);
        $card2cryptogateway_kryptonimcom_currency = get_woocommerce_currency();
		$card2cryptogateway_kryptonimcom_total = $order->get_total();
		$card2cryptogateway_kryptonimcom_nonce = wp_create_nonce( 'card2cryptogateway_kryptonimcom_nonce_' . $order_id );
		$card2cryptogateway_kryptonimcom_callback = add_query_arg(array('order_id' => $order_id, 'nonce' => $card2cryptogateway_kryptonimcom_nonce,), rest_url('card2cryptogateway/v1/card2cryptogateway-kryptonimcom/'));
		$card2cryptogateway_kryptonimcom_email = urlencode(sanitize_email($order->get_billing_email()));
		
		if ($card2cryptogateway_kryptonimcom_currency === 'USD') {
        $card2cryptogateway_kryptonimcom_final_total = $card2cryptogateway_kryptonimcom_total;
		$card2cryptogateway_kryptonimcom_reference_total = (float)$card2cryptogateway_kryptonimcom_final_total;
		} else {
		
$card2cryptogateway_kryptonimcom_response = wp_remote_get('https://api.card2crypto.org/control/convert.php?value=' . $card2cryptogateway_kryptonimcom_total . '&from=' . strtolower($card2cryptogateway_kryptonimcom_currency), array('timeout' => 30));

if (is_wp_error($card2cryptogateway_kryptonimcom_response)) {
    // Handle error
    card2cryptogateway_add_notice(__('Payment error:', 'instant-approval-payment-gateway') . __('Payment could not be processed due to failed currency conversion process, please try again', 'instant-approval-payment-gateway'), 'error');
    return null;
} else {

$card2cryptogateway_kryptonimcom_body = wp_remote_retrieve_body($card2cryptogateway_kryptonimcom_response);
$card2cryptogateway_kryptonimcom_conversion_resp = json_decode($card2cryptogateway_kryptonimcom_body, true);

if ($card2cryptogateway_kryptonimcom_conversion_resp && isset($card2cryptogateway_kryptonimcom_conversion_resp['value_coin'])) {
    // Escape output
    $card2cryptogateway_kryptonimcom_final_total	= sanitize_text_field($card2cryptogateway_kryptonimcom_conversion_resp['value_coin']);
    $card2cryptogateway_kryptonimcom_reference_total = (float)$card2cryptogateway_kryptonimcom_final_total;	
} else {
    card2cryptogateway_add_notice(__('Payment error:', 'instant-approval-payment-gateway') . __('Payment could not be processed, please try again (unsupported store currency)', 'instant-approval-payment-gateway'), 'error');
    return null;
}	
		}
		}
		
if ($card2cryptogateway_kryptonimcom_reference_total < 10) {
card2cryptogateway_add_notice(__('Payment error:', 'instant-approval-payment-gateway') . __('Order total for this payment provider must be $10 USD or more.', 'instant-approval-payment-gateway'), 'error');
return null;
}	
		
$card2cryptogateway_kryptonimcom_gen_wallet = wp_remote_get('https://api.card2crypto.org/control/wallet.php?address=' . $this->kryptonimcom_wallet_address .'&callback=' . urlencode($card2cryptogateway_kryptonimcom_callback), array('timeout' => 30));

if (is_wp_error($card2cryptogateway_kryptonimcom_gen_wallet)) {
    // Handle error
    card2cryptogateway_add_notice(__('Wallet error:', 'instant-approval-payment-gateway') . __('Payment could not be processed due to incorrect payout wallet settings, please contact website admin', 'instant-approval-payment-gateway'), 'error');
    return null;
} else {
	$card2cryptogateway_kryptonimcom_wallet_body = wp_remote_retrieve_body($card2cryptogateway_kryptonimcom_gen_wallet);
	$card2cryptogateway_kryptonimcom_wallet_decbody = json_decode($card2cryptogateway_kryptonimcom_wallet_body, true);

 // Check if decoding was successful
    if ($card2cryptogateway_kryptonimcom_wallet_decbody && isset($card2cryptogateway_kryptonimcom_wallet_decbody['address_in'])) {
        // Store the address_in as a variable
        $card2cryptogateway_kryptonimcom_gen_addressIn = wp_kses_post($card2cryptogateway_kryptonimcom_wallet_decbody['address_in']);
        $card2cryptogateway_kryptonimcom_gen_polygon_addressIn = sanitize_text_field($card2cryptogateway_kryptonimcom_wallet_decbody['polygon_address_in']);
		$card2cryptogateway_kryptonimcom_gen_callback = sanitize_url($card2cryptogateway_kryptonimcom_wallet_decbody['callback_url']);
		// Save $kryptonimcomresponse in order meta data
    $order->add_meta_data('card2crypto_kryptonimcom_tracking_address', $card2cryptogateway_kryptonimcom_gen_addressIn, true);
    $order->add_meta_data('card2crypto_kryptonimcom_polygon_temporary_order_wallet_address', $card2cryptogateway_kryptonimcom_gen_polygon_addressIn, true);
    $order->add_meta_data('card2crypto_kryptonimcom_callback', $card2cryptogateway_kryptonimcom_gen_callback, true);
	$order->add_meta_data('card2crypto_kryptonimcom_converted_amount', $card2cryptogateway_kryptonimcom_final_total, true);
	$order->add_meta_data('card2crypto_kryptonimcom_expected_amount', $card2cryptogateway_kryptonimcom_reference_total, true);
	$order->add_meta_data('card2crypto_kryptonimcom_nonce', $card2cryptogateway_kryptonimcom_nonce, true);
    $order->save();
    } else {
        card2cryptogateway_add_notice(__('Payment error:', 'instant-approval-payment-gateway') . __('Payment could not be processed, please try again (wallet address error)', 'instant-approval-payment-gateway'), 'error');

        return null;
    }
}

// Check if the Checkout page is using Checkout Blocks
if (card2cryptogateway_is_checkout_block()) {
    global $woocommerce;
	$woocommerce->cart->empty_cart();
}

        // Redirect to payment page
        return array(
            'result'   => 'success',
            'redirect' => 'https://' . $this->kryptonimcom_custom_domain . '/process-payment.php?address=' . $card2cryptogateway_kryptonimcom_gen_addressIn . '&amount=' . (float)$card2cryptogateway_kryptonimcom_total . '&provider=kryptonim&email=' . $card2cryptogateway_kryptonimcom_email . '&currency=' . $card2cryptogateway_kryptonimcom_currency,
        );
    }

public function card2crypto_instant_payment_gateway_get_icon_url() {
        return !empty($this->icon_url) ? esc_url($this->icon_url) : '';
    }
}

function card2cryptogateway_add_instant_payment_gateway_kryptonimcom($gateways) {
    $gateways[] = 'Card2Crypto_Instant_Payment_Gateway_Kryptonim';
    return $gateways;
}
add_filter('woocommerce_payment_gateways', 'card2cryptogateway_add_instant_payment_gateway_kryptonimcom');
}

// Add custom endpoint for changing order status
function card2cryptogateway_kryptonimcom_change_order_status_rest_endpoint() {
    // Register custom route
    register_rest_route( 'card2cryptogateway/v1', '/card2cryptogateway-kryptonimcom/', array(
        'methods'  => 'GET',
        'callback' => 'card2cryptogateway_kryptonimcom_change_order_status_callback',
        'permission_callback' => '__return_true',
    ));
}
add_action( 'rest_api_init', 'card2cryptogateway_kryptonimcom_change_order_status_rest_endpoint' );

// Callback function to change order status
function card2cryptogateway_kryptonimcom_change_order_status_callback( $request ) {
    $order_id = absint($request->get_param( 'order_id' ));
	$card2cryptogateway_kryptonimcomgetnonce = sanitize_text_field($request->get_param( 'nonce' ));
	$card2cryptogateway_kryptonimcompaid_txid_out = sanitize_text_field($request->get_param('txid_out'));
	$card2cryptogateway_kryptonimcompaid_value_coin = sanitize_text_field($request->get_param('value_coin'));
	$card2cryptogateway_kryptonimcomfloatpaid_value_coin = (float)$card2cryptogateway_kryptonimcompaid_value_coin;

    // Check if order ID parameter exists
    if ( empty( $order_id ) ) {
        return new WP_Error( 'missing_order_id', __( 'Order ID parameter is missing.', 'instant-approval-payment-gateway' ), array( 'status' => 400 ) );
    }

    // Get order object
    $order = wc_get_order( $order_id );

    // Check if order exists
    if ( ! $order ) {
        return new WP_Error( 'invalid_order', __( 'Invalid order ID.', 'instant-approval-payment-gateway' ), array( 'status' => 404 ) );
    }
	
	// Verify nonce
    if ( empty( $card2cryptogateway_kryptonimcomgetnonce ) || $order->get_meta('card2crypto_kryptonimcom_nonce', true) !== $card2cryptogateway_kryptonimcomgetnonce ) {
        return new WP_Error( 'invalid_nonce', __( 'Invalid nonce.', 'instant-approval-payment-gateway' ), array( 'status' => 403 ) );
    }

    // Check if the order is pending and payment method is 'card2crypto-kryptonim'
    if ( $order && $order->get_status() !== 'processing' && $order->get_status() !== 'completed' && 'card2crypto-kryptonim' === $order->get_payment_method() ) {
	$card2cryptogateway_kryptonimcomexpected_amount = (float)$order->get_meta('card2crypto_kryptonimcom_expected_amount', true);
	$card2cryptogateway_kryptonimcomthreshold = 0.60 * $card2cryptogateway_kryptonimcomexpected_amount;
		if ( $card2cryptogateway_kryptonimcomfloatpaid_value_coin < $card2cryptogateway_kryptonimcomthreshold ) {
			// Mark the order as failed and add an order note
            $order->update_status('failed', __( 'Payment received is less than 60% of the order total. Customer may have changed the payment values on the checkout page.', 'instant-approval-payment-gateway' ));
            /* translators: 1: Transaction ID */
            $order->add_order_note(sprintf( __( 'Order marked as failed: Payment received is less than 60%% of the order total. Customer may have changed the payment values on the checkout page. TXID: %1$s', 'instant-approval-payment-gateway' ), $card2cryptogateway_kryptonimcompaid_txid_out));
            return array( 'message' => 'Order status changed to failed due to partial payment.' );
			
		} else {
        // Change order status to processing
		$order->payment_complete();
		/* translators: 1: Transaction ID */
		$order->add_order_note( sprintf(__('Payment completed by the provider TXID: %1$s', 'instant-approval-payment-gateway'), $card2cryptogateway_kryptonimcompaid_txid_out) );
        // Return success response
        return array( 'message' => 'Order marked as paid and status changed.' );
		}
    } else {
        // Return error response if conditions are not met
        return new WP_Error( 'order_not_eligible', __( 'Order is not eligible for status change.', 'instant-approval-payment-gateway' ), array( 'status' => 400 ) );
    }
}
?>